package com.bycom.versapro.Activities;

import static com.bycom.versapro.Serializables.Constant.adMobHelper;
import static com.bycom.versapro.Serializables.Constant.appConfig;
import static com.bycom.versapro.Serializables.Constant.themeChanged;
import static com.bycom.versapro.Utils.AppUtil.EdgeToEdgeEnable;
import static com.bycom.versapro.Utils.PrefUtil.setNight;
import static com.bycom.versapro.Utils.AppUtil.adjustColorBrightness;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.view.View;
import android.view.ViewTreeObserver;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import android.widget.Toast;
import androidx.appcompat.app.AppCompatActivity;
import androidx.appcompat.app.AppCompatDelegate;
import androidx.appcompat.content.res.AppCompatResources;
import androidx.browser.customtabs.CustomTabsIntent;
import com.bycom.versapro.R;
import com.bycom.versapro.Utils.PrefUtil;
import com.google.android.material.card.MaterialCardView;
import com.google.android.material.materialswitch.MaterialSwitch;
import com.squareup.picasso.Picasso;


public class SettingsActivity extends AppCompatActivity{





    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_settings);
        EdgeToEdgeEnable(this,findViewById(R.id.rl_activity_settings));



        RelativeLayout rl_activity_settings = findViewById(R.id.rl_activity_settings);
        MaterialSwitch night_switch = findViewById(R.id.night_switch);
        ImageView iv_banner_image = findViewById(R.id.iv_banner_image);
        MaterialCardView mcv_share = findViewById(R.id.mcv_share);
        MaterialCardView mcv_more = findViewById(R.id.mcv_more);
        MaterialCardView mcv_privacy = findViewById(R.id.mcv_privacy);
        MaterialCardView mcv_terms = findViewById(R.id.mcv_terms);


        View toolbar = findViewById(R.id.toolbar);
        TextView tv_toolbar_title = toolbar.findViewById(R.id.tv_toolbar_title);
        ImageView iv_back = toolbar.findViewById(R.id.iv_toolbar_left);
        ImageView iv_settings = toolbar.findViewById(R.id.iv_toolbar_right);

        tv_toolbar_title.setText(R.string.settings_label);
        iv_back.setImageDrawable(AppCompatResources.getDrawable(this,R.drawable.ic_arrow));
        iv_settings.setVisibility(View.GONE);




        iv_back.setOnClickListener(v -> onBackPressed());


        night_switch.setChecked(PrefUtil.isNight());


        night_switch.setOnCheckedChangeListener((buttonView, isChecked) -> {
            themeChanged = !themeChanged;
            setNight(isChecked);
            setNightMode(isChecked);

        });




        iv_banner_image.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener() {
            @Override
            public void onGlobalLayout() {
                iv_banner_image.getViewTreeObserver().removeOnGlobalLayoutListener(this);
                Picasso.get().load(appConfig.app_settings.banner_image)
                        .resize(iv_banner_image.getWidth(), iv_banner_image.getHeight())
                        .centerCrop()
                        .into(iv_banner_image);
            }
        });




        mcv_share.setOnClickListener(v -> {
            Intent shareIntent = new Intent(Intent.ACTION_SEND);
            shareIntent.setType("text/plain");
            shareIntent.putExtra(Intent.EXTRA_TEXT, appConfig.app_settings.app_share_message);
            startActivity(Intent.createChooser(shareIntent, getString(R.string.app_name)));
        });

        mcv_more.setOnClickListener(v -> {
            try {
                Intent intent = new Intent(Intent.ACTION_VIEW, Uri.parse(appConfig.app_settings.more_apps_url));
                startActivity(intent);
            }catch (Exception e){
                Toast.makeText(SettingsActivity.this, R.string.no_app_found_for_link, Toast.LENGTH_SHORT).show();
            }

        });

        mcv_terms.setOnClickListener(v -> {
            CustomTabsIntent.Builder builder = new CustomTabsIntent.Builder();
            CustomTabsIntent customTabsIntent = builder.build();
            customTabsIntent.launchUrl(SettingsActivity.this, Uri.parse(appConfig.app_settings.terms_url));
        });

        mcv_privacy.setOnClickListener(v -> {
            CustomTabsIntent.Builder builder = new CustomTabsIntent.Builder();
            CustomTabsIntent customTabsIntent = builder.build();
            customTabsIntent.launchUrl(SettingsActivity.this, Uri.parse(appConfig.app_settings.privacy_url));
        });







        rl_activity_settings.setBackgroundColor(adjustColorBrightness(appConfig.app_settings.accent_color,10));
        getWindow().setNavigationBarColor(adjustColorBrightness(appConfig.app_settings.accent_color,10));


        adMobHelper.getInterstitialAdManager().showAd(this);

    }


    @Override
    public void finish() {

        if(themeChanged) {
            themeChanged = false;
            Intent resultIntent = new Intent();
            setResult(RESULT_OK, resultIntent);
        }

        super.finish();
    }

    private void setNightMode(Boolean isNight){
        if(isNight)
            AppCompatDelegate.setDefaultNightMode(AppCompatDelegate.MODE_NIGHT_YES);
        else
            AppCompatDelegate.setDefaultNightMode(AppCompatDelegate.MODE_NIGHT_NO);


        startActivity(new Intent(this,SettingsActivity.class));
        overridePendingTransition(R.anim.fade_in,R.anim.fade_out);
        finish();
    }





}